//
// CompactTrailingView.swift
//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import SwiftUI
import WidgetKit

struct CompactTrailingView: View {
    let endDate: Date

    var body: some View {
        HStack {
            Spacer()
            Image(systemName: "timer")
            Text(timerInterval: .now ... endDate)
            Spacer()
        }
    }
}

struct CompactTrailingView_Previews: PreviewProvider {
    static var previews: some View {
        CompactTrailingView(endDate: .now.addingTimeInterval(60))
            .previewContext(WidgetPreviewContext(family: .accessoryRectangular))
    }
}
